/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.noding.snapround;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.algorithm.Distance;
import org.locationtech.jts.algorithm.LineIntersector;
import org.locationtech.jts.algorithm.RobustLineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.noding.NodedSegmentString;
import org.locationtech.jts.noding.SegmentIntersector;
import org.locationtech.jts.noding.SegmentString;

public class SnapRoundingIntersectionAdder
implements SegmentIntersector {
    private static final int NEARNESS_FACTOR = 100;
    private LineIntersector li;
    private final List<Coordinate> intersections;
    private PrecisionModel precModel;
    private double nearnessTol;

    public SnapRoundingIntersectionAdder(PrecisionModel pm) {
        this.precModel = pm;
        double snapGridSize = 1.0 / this.precModel.getScale();
        this.nearnessTol = snapGridSize / 100.0;
        this.li = new RobustLineIntersector();
        this.intersections = new ArrayList<Coordinate>();
    }

    public List<Coordinate> getIntersections() {
        return this.intersections;
    }

    @Override
    public void processIntersections(SegmentString e0, int segIndex0, SegmentString e1, int segIndex1) {
        if (e0 == e1 && segIndex0 == segIndex1) {
            return;
        }
        Coordinate p00 = e0.getCoordinates()[segIndex0];
        Coordinate p01 = e0.getCoordinates()[segIndex0 + 1];
        Coordinate p10 = e1.getCoordinates()[segIndex1];
        Coordinate p11 = e1.getCoordinates()[segIndex1 + 1];
        this.li.computeIntersection(p00, p01, p10, p11);
        if (this.li.hasIntersection() && this.li.isInteriorIntersection()) {
            for (int intIndex = 0; intIndex < this.li.getIntersectionNum(); ++intIndex) {
                this.intersections.add(this.li.getIntersection(intIndex));
            }
            ((NodedSegmentString)e0).addIntersections(this.li, segIndex0, 0);
            ((NodedSegmentString)e1).addIntersections(this.li, segIndex1, 1);
            return;
        }
        this.processNearVertex(p00, e1, segIndex1, p10, p11);
        this.processNearVertex(p01, e1, segIndex1, p10, p11);
        this.processNearVertex(p10, e0, segIndex0, p00, p01);
        this.processNearVertex(p11, e0, segIndex0, p00, p01);
    }

    private void processNearVertex(Coordinate p, SegmentString edge, int segIndex, Coordinate p0, Coordinate p1) {
        if (p.distance(p0) < this.nearnessTol) {
            return;
        }
        if (p.distance(p1) < this.nearnessTol) {
            return;
        }
        double distSeg = Distance.pointToSegment(p, p0, p1);
        if (distSeg < this.nearnessTol) {
            this.intersections.add(p);
            ((NodedSegmentString)edge).addIntersection(p, segIndex);
        }
    }

    @Override
    public boolean isDone() {
        return false;
    }
}

